/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.fsp.FSPCmdMgr;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class FspIoUnit {
    private String mType;
    private String mModel;
    private String mSerial;
    private String mLocationCode;
    private UnsignedInt16 mSpcnId;
    private UnsignedInt16 mUnitId;
    private UnsignedInt16[] mBusIds;
    private UnsignedInt32[] mBridgetDrcs;
    private UnsignedInt8[] mBridgetSwitchable;
    private UnsignedInt16[] mBridgetNumBuses;
    private static final String GET_ALL_IO_UNIT_IDS = "GET_ALL_IO_UNIT_IDS";
    private static final String GET_ALL_IO_UNIT_IDS_OLD = "GET_ALL_IO_UNIT_IDS_OLD";
    private static final String IO_UNIT_ID_LIST = "IO_UNIT_ID_LIST";
    private static final String IO_UNIT_ID = "IO_UNIT_ID";
    private static final String GET_IO_UNIT_INFO = "GET_IO_UNIT_INFO";
    private static final String GET_IO_INFO = "GET_IO_INFO";
    private static final String IO_BUS_ID_LIST = "IO_BUS_ID_LIST";
    private static final String IO_UNIT_MTMS_LIST = "IO_UNIT_MTMS_LIST";
    private static final String TYPE = "TYPE";
    private static final String MODEL = "MODEL";
    private static final String SERIAL_NUMBER = "SERIAL_NUMBER";
    private static final String IO_SLOT_LIST = "IO_SLOT_LIST";
    private static final String IO_BUS_ID = "IO_BUS_ID";
    private static final String SPCN_ID = "SPCN_ID";
    private static final String LOC_CODE = "LOC_CODE";
    private static final String DRC_INDEX = "DRC_INDEX";
    private static final String IO_LOCATION_CODE = "IO_LOCATION_CODE";
    private static final String SWITCHABLE = "SWITCHABLE";
    private static final String NUM_BUSES = "NUM_BUSES";
    private static final String NUM_BRIDGETS = "NUM_BRIDGETS";
    private static final String OFFSET_TOKEN = "OFFSET_TOKEN";
    private static final String REMAINING = "REMAINING";
    private static final String IO_BRIDGET_LIST = "IO_BRIDGET_LIST";

    FspIoUnit() {
    }

    static FspIoUnit[] getAllIoUnitIdsCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException, PIHscCmdMgrException {
        FspIoUnit[] fspIoUnitArray;
        Hashtable hashtable = null;
        File file = new File("/opt/hsc/data/phyp440");
        if (file.exists()) {
            hashtable = fSPCmdMgr.doPhypCommand(GET_ALL_IO_UNIT_IDS_OLD, null);
            Object[] objectArray = (Object[])hashtable.get(IO_UNIT_ID_LIST);
            if (objectArray == null || objectArray.length < 1) {
                return new FspIoUnit[0];
            }
            fspIoUnitArray = new FspIoUnit[objectArray.length];
            for (int i = 0; i < fspIoUnitArray.length; ++i) {
                fspIoUnitArray[i] = new FspIoUnit();
                Hashtable hashtable2 = (Hashtable)objectArray[i];
                fspIoUnitArray[i].mUnitId = (UnsignedInt16)hashtable2.get(IO_UNIT_ID);
            }
        } else {
            Vector vector = new Vector();
            boolean bl = true;
            UnsignedInt16 unsignedInt16 = new UnsignedInt16(0);
            while (bl) {
                hashtable = fSPCmdMgr.doPhypCommand(GET_ALL_IO_UNIT_IDS, new String[]{unsignedInt16.toString()});
                Object[] objectArray = (Object[])hashtable.get(IO_UNIT_ID_LIST);
                if (objectArray == null || objectArray.length < 1) {
                    bl = false;
                    continue;
                }
                long l = ((UnsignedInt16)hashtable.get(REMAINING)).longValue();
                if (l <= 0L) {
                    bl = false;
                } else {
                    unsignedInt16 = (UnsignedInt16)hashtable.get(OFFSET_TOKEN);
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    vector.add(((Hashtable)objectArray[i]).get(IO_LOCATION_CODE));
                }
            }
            fspIoUnitArray = new FspIoUnit[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                fspIoUnitArray[i] = new FspIoUnit();
                fspIoUnitArray[i].mLocationCode = ((String)vector.elementAt(i)).trim();
            }
        }
        return fspIoUnitArray;
    }

    FspIoUnit getIoUnitInfoCmd(FSPCmdMgr fSPCmdMgr, String string, String string2, String string3, UnsignedInt16 unsignedInt16) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        try {
            hashtable = fSPCmdMgr.doPhypCommand(GET_IO_UNIT_INFO, new String[]{unsignedInt16.toString()});
            this.mType = ((String)hashtable.get(TYPE)).trim();
            this.mModel = ((String)hashtable.get(MODEL)).trim();
            this.mSerial = ((String)hashtable.get(SERIAL_NUMBER)).trim();
            this.mUnitId = unsignedInt16;
            Object[] objectArray = (Object[])hashtable.get(IO_BUS_ID_LIST);
            this.mBusIds = new UnsignedInt16[objectArray.length];
            this.mLocationCode = "U" + this.mType + this.mModel + this.mSerial;
            for (int i = 0; i < objectArray.length; ++i) {
                Hashtable hashtable2 = (Hashtable)objectArray[i];
                this.mBusIds[i] = (UnsignedInt16)hashtable2.get(IO_BUS_ID);
            }
            return this;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    FspIoUnit getIoInfoCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException, PIHscCmdMgrException {
        int n;
        int n2 = 4 - string.length() % 4;
        for (int i = 0; i < n2; ++i) {
            string = string + "\u0000";
        }
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_IO_INFO, new String[]{String.valueOf(string.length()), ByteUtilities.toHexString(string.getBytes())});
        int n3 = ((UnsignedInt16)hashtable.get(NUM_BRIDGETS)).intValue();
        this.mBridgetDrcs = new UnsignedInt32[n3];
        this.mBridgetSwitchable = new UnsignedInt8[n3];
        this.mBridgetNumBuses = new UnsignedInt16[n3];
        Vector vector = new Vector();
        Object[] objectArray = (Object[])hashtable.get(IO_BRIDGET_LIST);
        this.mLocationCode = string.trim();
        for (n = 0; n < n3; ++n) {
            Hashtable hashtable2 = (Hashtable)objectArray[n];
            this.mBridgetDrcs[n] = (UnsignedInt32)hashtable2.get(DRC_INDEX);
            this.mBridgetSwitchable[n] = (UnsignedInt8)hashtable2.get(SWITCHABLE);
            this.mBridgetNumBuses[n] = (UnsignedInt16)hashtable2.get(NUM_BUSES);
            Object[] objectArray2 = (Object[])hashtable2.get(IO_BUS_ID_LIST);
            if (objectArray2 == null) continue;
            for (int i = 0; i < objectArray2.length; ++i) {
                Hashtable hashtable3 = (Hashtable)objectArray2[i];
                vector.add(hashtable3.get(IO_BUS_ID));
            }
        }
        this.mBusIds = new UnsignedInt16[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            this.mBusIds[n] = (UnsignedInt16)vector.elementAt(n);
        }
        return this;
    }

    public String getType() {
        return this.mType;
    }

    public String getModel() {
        return this.mModel;
    }

    public UnsignedInt16[] getBusIds() {
        return this.mBusIds;
    }

    public String getSerial() {
        return this.mSerial;
    }

    public String getLocationCode() {
        return this.mLocationCode;
    }

    public UnsignedInt16 getSpcnId() {
        return this.mSpcnId;
    }

    public UnsignedInt16 getUnitId() {
        return this.mUnitId;
    }

    public String toString() {
        String string = "type=";
        String string2 = "model=";
        String string3 = "serial=";
        String string4 = "busIds=";
        String string5 = "unitId=";
        String string6 = "locationCode=";
        if (this.mType != null) {
            string = string + this.mType.toString();
        }
        if (this.mModel != null) {
            string2 = string2 + this.mModel.toString();
        }
        if (this.mSerial != null) {
            string3 = string3 + this.mSerial.toString();
        }
        if (this.mBusIds != null) {
            for (int i = 0; i < this.mBusIds.length; ++i) {
                string4 = string4 + this.mBusIds[i].toString() + " ";
            }
        }
        if (this.mUnitId != null) {
            string5 = string5 + this.mUnitId.toString();
        }
        if (this.mLocationCode != null) {
            string6 = string6 + this.mLocationCode;
        }
        return string + "; " + string2 + "; " + string3 + "; " + string4 + "; " + string5 + "; " + string6;
    }
}

